package
{
	//importing the main classes
	import flash.display.*;
	import flash.geom.*;
	import flash.media.*;
    import flash.net.*;
	import flash.events.*;
	import flash.utils.*;
    import flash.xml.*;
	import flash.text.*;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.*;
	public class Asset extends MovieClip
	{
		
		public var l:Loader = new Loader;
		//you can modify the border color and width from here.
		public var bcolor:uint = 0xFFF0FF;
		public var bwidth:int = 4;
		public var w:int;
		public var h:int;
		public var bdata:BitmapData ;
		public var bmpaux:Bitmap;
		public var bg:Sprite = new Sprite();
		private var loader_mc:MovieClip = new Preloader();
		public var borders:MovieClip = new MovieClip();
		
		public var b1:Shape = new Shape();
		public var b2:Shape = new Shape();
		public var b3:Shape = new Shape();
		public var b4:Shape = new Shape();
		
		public var index:int = 0;
		public var feed:String;
		public var type:String;
		public var description:String;
		private var play_mc:VideoBtn = new VideoBtn();
		private var swf_mc:FlashBtn = new FlashBtn();
		private var you_mc:YouTubeBtn = new YouTubeBtn();
		public var bmp:MovieClip = new MovieClip();
		
		public function Asset(feed:String,pw:int,ph:int,ptype:String="image")
		{
			
			w = pw;
			h = ph;
			
			
			
			//we add a background while the asset is loading
			
				bg.graphics.beginFill(0x000000);
				bg.graphics.drawRect(0, 0, w, h);
				addChild(bg);
			
				loader_mc.x = w / 2;
				loader_mc.y = h / 2;
				addChild(loader_mc);
			//simple load function
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete)
			
			b1.graphics.beginFill(bcolor);
				b1.graphics.drawRect(0, 0, bwidth, h);
				borders.addChild(b1);
				
				b2.graphics.beginFill(bcolor);
				b2.graphics.drawRect(0, 0, w, bwidth);
				borders.addChild(b2);
				
				b3.graphics.beginFill(bcolor);
				b3.graphics.drawRect(0, 0, bwidth, h);
				b3.x = w - bwidth;
				borders.addChild(b3);
		
				b4.graphics.beginFill(bcolor);
				b4.graphics.drawRect(0, 0, w,  bwidth);
				b4.y = h - bwidth;
				borders.addChild(b4);
				
			addChild(borders);
			l.load(new URLRequest(feed));
			function onComplete(e:Event)
			{
				//we scale the assets after has loaded
				removeChild(loader_mc);
				dispatchEvent(new Event("loaded"));
				bdata = new BitmapData(l.content.width, l.content.height, true, 0x000000);
				bdata.draw(l.content);
				bmpaux = new Bitmap(bdata);
				//we smooth the background
				bmpaux.width = w;
				bmpaux.height = h;
				bmpaux.smoothing = true;
				bmpaux.alpha = 0;
				Tweener.addTween(bmpaux, { alpha:1, time:1 } );
				addChildAt(bmp,1);
				bmp.addChild(bmpaux);
				if (ptype == "swf")
				{
				swf_mc.x = w >> 1;
				swf_mc.y = h >> 1;
				bmp.addChild(swf_mc);
				}
				
				
				if (ptype == "video")
				{
				play_mc.x = w >> 1;
				play_mc.y = h >> 1;
				bmp.addChild(play_mc);
				}
				
				if (ptype == "youtube")
				{
				you_mc.x = w >> 1;
				you_mc.y = h >> 1;
				bmp.addChild(you_mc);
				}
				
			}
		}
		
		public function resizeBorders(arg:Number)
		{
			
				Tweener.addTween(b1, { width:arg, height:h, time:1 } );	
				Tweener.addTween(b2, { width:w, height:arg, time:1 } );
				Tweener.addTween(b3, { x:w-arg, width:arg, height:h, time:1 } );
				Tweener.addTween(b4, { y:h-arg, width:w, height:arg, time:1 } );
				
				
		}
		
	}
}